<?php
$pageTitle = 'Templates';
require_once __DIR__ . '/includes/layout.php';

$userId = getCurrentUserId();

$templates = dbFetchAll(
    "SELECT * FROM templates WHERE user_id = ? ORDER BY category, name",
    [$userId]
);

$categories = dbFetchAll(
    "SELECT DISTINCT category FROM templates WHERE user_id = ? AND category IS NOT NULL ORDER BY category",
    [$userId]
);
?>
    <header class="page-header">
        <h1 class="page-title">Templates</h1>
        <button class="btn btn-primary" data-modal="modal-template">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" style="width: 1rem; height: 1rem;">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.5v15m7.5-7.5h-15" />
            </svg>
            Nuevo
        </button>
    </header>

    <div class="page-content">
        <?php if (empty($templates)): ?>
        <div class="card">
            <div class="empty-state">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M4.095 9.279a2.25 2.25 0 012.25-2.25h2.25a2.25 2.25 0 012.25 2.25v2.25a2.25 2.25 0 01-2.25 2.25H6a2.25 2.25 0 01-2.25-2.25V9zM3.75 15.75a2.25 2.25 0 012.25-2.25h2.25a2.25 2.25 0 012.25 2.25V18a2.25 2.25 0 01-2.25 2.25H6A2.25 2.25 0 013.75 18v-2.25zM13.5 6a2.25 2.25 0 012.25-2.25h2.25A2.25 2.25 0 0120.25 6v2.25A2.25 2.25 0 0118 10.5h-2.25a2.25 2.25 0 01-2.25-2.25V6zM13.5 15.75a2.25 2.25 0 012.25-2.25h2.25a2.25 2.25 0 012.25 2.25V18A2.25 2.25 0 0118 20.25h-2.25A2.25 2.25 0 0113.5 18v-2.25z" />
                </svg>
                <p>No hay templates creados</p>
                <p style="font-size: 0.875rem;">Crea textos repetitivos para usar en tus propuestas</p>
            </div>
        </div>
        <?php else: ?>
            <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 1rem;">
                <?php foreach ($templates as $t): ?>
                <div class="card">
                    <div class="card-header" style="display: flex; align-items: center; justify-content: space-between;">
                        <div>
                            <h3 class="card-title"><?= htmlspecialchars($t['name']) ?></h3>
                            <?php if ($t['category']): ?>
                                <span style="font-size: 0.75rem; color: var(--text-muted);"><?= htmlspecialchars($t['category']) ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="actions-cell">
                            <button class="btn btn-icon btn-sm" onclick="copyTemplate(<?= $t['id'] ?>)" title="Copiar">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" style="width: 1rem; height: 1rem;">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M15.666 3.888A2.25 2.25 0 0013.5 2.25h-3c-1.03 0-1.9.693-2.166 1.638m7.332 0c.055.194.084.4.084.612v0a.75.75 0 01-.75.75H9.75a.75.75 0 01-.75-.75v0c0-.212.03-.418.084-.612m7.332 0c.646.049 1.288.11 1.927.184 1.1.128 1.907 1.077 1.907 2.185V19.5a2.25 2.25 0 01-2.25 2.25H6.75A2.25 2.25 0 014.5 19.5V6.257c0-1.108.806-2.057 1.907-2.185a48.208 48.208 0 011.927-.184" />
                                </svg>
                            </button>
                            <button class="btn btn-icon btn-sm" onclick="editTemplate(<?= $t['id'] ?>)" title="Editar">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" style="width: 1rem; height: 1rem;">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L6.832 19.82a4.5 4.5 0 01-1.897 1.13l-2.685.8.8-2.685a4.5 4.5 0 011.13-1.897L16.863 4.487zm0 0L19.5 7.125" />
                                </svg>
                            </button>
                            <button class="btn btn-icon btn-sm" onclick="deleteTemplate(<?= $t['id'] ?>)" title="Eliminar" style="color: var(--danger);">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" style="width: 1rem; height: 1rem;">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M14.74 9l-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 01-2.244 2.077H8.084a2.25 2.25 0 01-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 00-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 013.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 00-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 00-7.5 0" />
                                </svg>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <p style="color: var(--text-secondary); font-size: 0.875rem; white-space: pre-wrap;"><?= htmlspecialchars(truncateText($t['content'], 150)) ?></p>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <div class="modal-overlay" id="modal-template">
        <div class="modal" style="max-width: 600px;">
            <div class="modal-header">
                <h3 class="modal-title">Nuevo Template</h3>
                <button class="modal-close" data-close>&times;</button>
            </div>
            <form id="form-template" class="modal-body">
                <input type="hidden" name="id" id="template-id">
                <div class="input-group">
                    <label class="input-label">Nombre *</label>
                    <input type="text" name="name" class="input" required>
                </div>
                <div class="input-group">
                    <label class="input-label">Categoría</label>
                    <input type="text" name="category" class="input" list="categories-list">
                    <datalist id="categories-list">
                        <?php foreach ($categories as $c): ?>
                            <option value="<?= htmlspecialchars($c['category']) ?>">
                        <?php endforeach; ?>
                    </datalist>
                </div>
                <div class="input-group">
                    <label class="input-label">Contenido *</label>
                    <textarea name="content" class="input" rows="8" required placeholder="Escribe aquí tu texto repetitivo..."></textarea>
                </div>
            </form>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-close>Cancelar</button>
                <button type="submit" form="form-template" class="btn btn-primary">Guardar</button>
            </div>
        </div>
    </div>
</main>
<script src="/assets/js/app.js"></script>
<script src="/assets/js/templates.js"></script>
</body>
</html>
