<?php
$pageTitle = 'Propuestas';
require_once __DIR__ . '/includes/layout.php';

$userId = getCurrentUserId();

$where = ['user_id = ?'];
$params = [$userId];

$sourceFilter = $_GET['source'] ?? '';
$statusFilter = $_GET['status'] ?? '';
$dateFrom = $_GET['date_from'] ?? '';
$dateTo = $_GET['date_to'] ?? '';
$search = $_GET['search'] ?? '';

if ($sourceFilter) {
    $where[] = 'source = ?';
    $params[] = $sourceFilter;
}

if ($statusFilter) {
    $where[] = 'status = ?';
    $params[] = $statusFilter;
}

if ($dateFrom) {
    $where[] = 'DATE(created_at) >= ?';
    $params[] = $dateFrom;
}

if ($dateTo) {
    $where[] = 'DATE(created_at) <= ?';
    $params[] = $dateTo;
}

if ($search) {
    $where[] = '(title LIKE ? OR description LIKE ?)';
    $params[] = "%$search%";
    $params[] = "%$search%";
}

$whereClause = implode(' AND ', $where);

$page = max(1, (int)($_GET['page'] ?? 1));
$perPage = 20;
$offset = ($page - 1) * $perPage;

$total = dbFetchOne("SELECT COUNT(*) as count FROM proposals WHERE $whereClause", $params)['count'] ?? 0;
$proposals = dbFetchAll(
    "SELECT * FROM proposals WHERE $whereClause ORDER BY created_at DESC LIMIT $perPage OFFSET $offset",
    $params
);

$totalPages = max(1, (int)ceil($total / $perPage));

$sources = ['upwork' => 'Upwork', 'workana' => 'Workana', 'freelancer' => 'Freelancer', 'fiverr' => 'Fiverr'];
$statuses = ['pending' => 'Pendiente', 'applied' => 'Aplicado', 'rejected' => 'Rechazado'];
?>
    <header class="page-header">
        <h1 class="page-title">Propuestas</h1>
        <button class="btn btn-primary" data-modal="modal-proposal">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" style="width: 1rem; height: 1rem;">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.5v15m7.5-7.5h-15" />
            </svg>
            Nueva
        </button>
    </header>

    <div class="page-content">
        <form method="GET" class="filters-bar">
            <div class="filter-group" style="flex: 2;">
                <label>Buscar</label>
                <input type="text" name="search" value="<?= htmlspecialchars($search) ?>" placeholder="Título o descripción...">
            </div>
            <div class="filter-group">
                <label>Fuente</label>
                <select name="source">
                    <option value="">Todas</option>
                    <?php foreach ($sources as $key => $label): ?>
                        <option value="<?= $key ?>" <?= $sourceFilter === $key ? 'selected' : '' ?>><?= $label ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="filter-group">
                <label>Estado</label>
                <select name="status">
                    <option value="">Todos</option>
                    <?php foreach ($statuses as $key => $label): ?>
                        <option value="<?= $key ?>" <?= $statusFilter === $key ? 'selected' : '' ?>><?= $label ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="filter-group">
                <label>Desde</label>
                <input type="date" name="date_from" value="<?= htmlspecialchars($dateFrom) ?>">
            </div>
            <div class="filter-group">
                <label>Hasta</label>
                <input type="date" name="date_to" value="<?= htmlspecialchars($dateTo) ?>">
            </div>
            <div class="filter-group" style="flex: 0;">
                <label>&nbsp;</label>
                <button type="submit" class="btn btn-primary">Filtrar</button>
            </div>
            <div class="filter-group" style="flex: 0;">
                <label>&nbsp;</label>
                <a href="/proposals.php" class="btn btn-secondary">Limpiar</a>
            </div>
        </form>

        <div class="card">
            <div class="table-wrapper">
                <table class="table">
                    <thead>
                        <tr>
                            <th style="width: 35%;">Título</th>
                            <th>Fuente</th>
                            <th>Presupuesto</th>
                            <th>Estado</th>
                            <th>Fecha</th>
                            <th style="width: 120px;">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($proposals)): ?>
                        <tr>
                            <td colspan="6">
                                <div class="empty-state">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m0 12.75h7.5m-7.5 3H12M10.5 2.25H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z" />
                                    </svg>
                                    <p>No se encontraron propuestas</p>
                                </div>
                            </td>
                        </tr>
                        <?php else: ?>
                            <?php foreach ($proposals as $p): ?>
                            <tr>
                                <td>
                                    <div style="font-weight: 500;"><?= htmlspecialchars(truncateText($p['title'], 50)) ?></div>
                                    <?php if ($p['url']): ?>
                                        <a href="<?= htmlspecialchars($p['url']) ?>" target="_blank" style="font-size: 0.75rem; color: #60a5fa;">Ver original</a>
                                    <?php endif; ?>
                                </td>
                                <td><span class="badge badge-<?= $p['source'] ?>"><?= htmlspecialchars(getSourceLabel($p['source'])) ?></span></td>
                                <td><?= $p['budget'] ? formatMoney((float)$p['budget']) : '-' ?></td>
                                <td><?= getStatusBadge($p['status']) ?></td>
                                <td style="color: var(--text-muted); font-size: 0.875rem;"><?= formatDate($p['created_at']) ?></td>
                                <td>
                                    <div class="actions-cell">
                                        <button class="btn btn-icon btn-sm" onclick="editProposal(<?= $p['id'] ?>)" title="Editar">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" style="width: 1rem; height: 1rem;">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L6.832 19.82a4.5 4.5 0 01-1.897 1.13l-2.685.8.8-2.685a4.5 4.5 0 011.13-1.897L16.863 4.487zm0 0L19.5 7.125" />
                                            </svg>
                                        </button>
                                        <button class="btn btn-icon btn-sm" onclick="deleteProposal(<?= $p['id'] ?>)" title="Eliminar" style="color: var(--danger);">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" style="width: 1rem; height: 1rem;">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M14.74 9l-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 01-2.244 2.077H8.084a2.25 2.25 0 01-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 00-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 013.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 00-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 00-7.5 0" />
                                            </svg>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php if ($totalPages > 1): ?>
            <div style="display: flex; align-items: center; justify-content: space-between; padding: 1rem 1.25rem; border-top: 1px solid var(--border-color);">
                <div style="color: var(--text-muted); font-size: 0.875rem;">
                    Mostrando <?= ($page - 1) * $perPage + 1 ?> - <?= min($page * $perPage, $total) ?> de <?= $total ?>
                </div>
                <div style="display: flex; gap: 0.5rem;">
                    <?php if ($page > 1): ?>
                        <a href="?<?= http_build_query(array_merge($_GET, ['page' => $page - 1])) ?>" class="btn btn-sm btn-secondary">Anterior</a>
                    <?php endif; ?>
                    <?php if ($page < $totalPages): ?>
                        <a href="?<?= http_build_query(array_merge($_GET, ['page' => $page + 1])) ?>" class="btn btn-sm btn-secondary">Siguiente</a>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="modal-overlay" id="modal-proposal">
        <div class="modal">
            <div class="modal-header">
                <h3 class="modal-title">Nueva Propuesta</h3>
                <button class="modal-close" data-close>&times;</button>
            </div>
            <form id="form-proposal" class="modal-body">
                <input type="hidden" name="id" id="proposal-id">
                <div class="input-group">
                    <label class="input-label">Título *</label>
                    <input type="text" name="title" class="input" required>
                </div>
                <div class="input-group">
                    <label class="input-label">Descripción</label>
                    <textarea name="description" class="input" rows="4"></textarea>
                </div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                    <div class="input-group">
                        <label class="input-label">Fuente *</label>
                        <select name="source" class="input" required>
                            <option value="">Seleccionar</option>
                            <?php foreach ($sources as $key => $label): ?>
                                <option value="<?= $key ?>"><?= $label ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="input-group">
                        <label class="input-label">Presupuesto</label>
                        <input type="number" name="budget" class="input" step="0.01">
                    </div>
                </div>
                <div class="input-group">
                    <label class="input-label">URL</label>
                    <input type="url" name="url" class="input">
                </div>
                <div class="input-group">
                    <label class="input-label">Estado</label>
                    <select name="status" class="input">
                        <?php foreach ($statuses as $key => $label): ?>
                            <option value="<?= $key ?>" <?= $key === 'pending' ? 'selected' : '' ?>><?= $label ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </form>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-close>Cancelar</button>
                <button type="submit" form="form-proposal" class="btn btn-primary">Guardar</button>
            </div>
        </div>
    </div>
</main>
<script src="/assets/js/app.js"></script>
<script src="/assets/js/proposals.js"></script>
</body>
</html>
