<?php
declare(strict_types=1);
define('ZAO_ROOT', __DIR__);

require_once ZAO_ROOT . '/includes/db.php';
require_once ZAO_ROOT . '/includes/auth.php';
require_once ZAO_ROOT . '/includes/functions.php';

if (isLoggedIn()) {
    header('Location: /dashboard.php');
    exit;
}

$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = sanitizeString($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $remember = !empty($_POST['remember']);

    if ($email && $password) {
        if (login($email, $password, $remember)) {
            header('Location: /dashboard.php');
            exit;
        }
        $error = 'Credenciales inválidas';
    } else {
        $error = 'Completa todos los campos';
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ZAO - Login</title>
    <link rel="stylesheet" href="/assets/css/styles.css">
</head>
<body>
    <div class="login-container">
        <div class="card login-card">
            <div class="card-body">
                <div class="login-header">
                    <h1 class="login-title"><span style="color: #60a5fa;">ZAO</span></h1>
                    <p class="login-subtitle">Sistema de Gestión de Propuestas</p>
                </div>

                <?php if ($error): ?>
                    <div class="alert alert-error"><?= htmlspecialchars($error) ?></div>
                <?php endif; ?>

                <form method="POST">
                    <div class="input-group">
                        <label class="input-label">Email</label>
                        <input
                            type="email"
                            name="email"
                            class="input"
                            placeholder="tu@email.com"
                            required
                            autofocus
                        >
                    </div>

                    <div class="input-group">
                        <label class="input-label">Contraseña</label>
                        <input
                            type="password"
                            name="password"
                            class="input"
                            placeholder="••••••••"
                            required
                        >
                    </div>

                    <div class="input-group">
                        <label class="checkbox-group">
                            <input type="checkbox" name="remember" class="checkbox">
                            <span style="font-size: 0.875rem; color: var(--text-secondary);">Recordarme</span>
                        </label>
                    </div>

                    <button type="submit" class="btn btn-primary" style="width: 100%;">
                        Iniciar Sesión
                    </button>
                </form>
            </div>
        </div>
    </div>
</body>
</html>
