<?php
declare(strict_types=1);
if (!defined('ZAO_ROOT')) {
    define('ZAO_ROOT', dirname(__DIR__));
}

require_once ZAO_ROOT . '/includes/db.php';
require_once ZAO_ROOT . '/includes/auth.php';
require_once ZAO_ROOT . '/includes/functions.php';

requireAuth();

$user = getCurrentUser();
$currentPage = basename($_SERVER['PHP_SELF']);
$navItems = [
    ['page' => 'dashboard.php', 'label' => 'Dashboard', 'icon' => 'dashboard'],
    ['page' => 'proposals.php', 'label' => 'Propuestas', 'icon' => 'proposals'],
    ['page' => 'templates.php', 'label' => 'Templates', 'icon' => 'templates'],
    ['page' => 'filters.php', 'label' => 'Filtros', 'icon' => 'filters'],
];

function isActiveNav(string $page): string {
    global $currentPage;
    return basename($page) === $currentPage ? 'active' : '';
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'ZAO' ?></title>
    <link rel="stylesheet" href="/assets/css/styles.css">
    <?php if ($customStyles ?? false): ?>
    <style><?= $customStyles ?></style>
    <?php endif; ?>
</head>
<body>
    <button class="mobile-menu-btn btn btn-icon" style="position: fixed; top: 1rem; left: 1rem; z-index: 101;">
        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" />
        </svg>
    </button>

    <div class="sidebar-overlay" style="display: none;"></div>

    <nav class="nav-sidebar">
        <div class="nav-header">
            <a href="/dashboard.php" class="nav-logo">
                <span style="color: #60a5fa;">ZAO</span>
            </a>
        </div>

        <div class="nav-menu">
            <?php foreach ($navItems as $item): ?>
            <a href="/<?= $item['page'] ?>" class="nav-item <?= isActiveNav($item['page']) ?>">
                <?php if ($item['icon'] === 'dashboard'): ?>
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6A2.25 2.25 0 016 3.75h2.25A2.25 2.25 0 0110.5 6v2.25a2.25 2.25 0 01-2.25 2.25H6a2.25 2.25 0 01-2.25-2.25V6zM3.75 15.75A2.25 2.25 0 016 13.5h2.25a2.25 2.25 0 012.25 2.25V18a2.25 2.25 0 01-2.25 2.25H6A2.25 2.25 0 013.75 18v-2.25zM13.5 6a2.25 2.25 0 012.25-2.25H18A2.25 2.25 0 0120.25 6v2.25A2.25 2.25 0 0118 10.5h-2.25a2.25 2.25 0 01-2.25-2.25V6zM13.5 15.75a2.25 2.25 0 012.25-2.25H18a2.25 2.25 0 012.25 2.25V18A2.25 2.25 0 0118 20.25h-2.25A2.25 2.25 0 0113.5 18v-2.25z" />
                </svg>
                <?php elseif ($item['icon'] === 'proposals'): ?>
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m2.25 0H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z" />
                </svg>
                <?php elseif ($item['icon'] === 'templates'): ?>
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M4.095 9.279a2.25 2.25 0 002.25 2.25h2.25a2.25 2.25 0 002.25-2.25V9m0 0a2.25 2.25 0 012.25-2.25h2.25A2.25 2.25 0 0115.345 9v2.25m-9-6h12a2.25 2.25 0 012.25 2.25v12a2.25 2.25 0 01-2.25 2.25h-12a2.25 2.25 0 01-2.25-2.25v-12a2.25 2.25 0 012.25-2.25z" />
                </svg>
                <?php elseif ($item['icon'] === 'filters'): ?>
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 3c2.755 0 5.455.232 8.083.678.533.09.917.556.917 1.096v1.044a2.25 2.25 0 01-.659 1.591l-5.432 5.432a2.25 2.25 0 00-.659 1.591v2.927a2.25 2.25 0 01-1.244 2.013L9.75 21v-6.568a2.25 2.25 0 00-.659-1.591L3.659 7.409A2.25 2.25 0 013 5.818V4.774c0-.54.384-1.006.917-1.096A48.32 48.32 0 0112 3z" />
                </svg>
                <?php endif; ?>
                <span><?= $item['label'] ?></span>
            </a>
            <?php endforeach; ?>
        </div>

        <div class="nav-footer">
            <div style="display: flex; align-items: center; gap: 0.75rem; padding: 0.5rem;">
                <div style="width: 36px; height: 36px; background: linear-gradient(135deg, #0e448f, #1e40af); border-radius: 9999px; display: flex; align-items: center; justify-content: center; font-weight: 600;">
                    <?= strtoupper(substr($user['name'] ?: 'A', 0, 1)) ?>
                </div>
                <div style="flex: 1; min-width: 0;">
                    <div style="font-size: 0.875rem; font-weight: 500; overflow: hidden; text-overflow: ellipsis;"><?= htmlspecialchars($user['name'] ?: 'Usuario') ?></div>
                    <div style="font-size: 0.75rem; color: var(--text-muted); overflow: hidden; text-overflow: ellipsis;"><?= htmlspecialchars($user['email']) ?></div>
                </div>
            </div>
            <a href="/logout.php" class="btn btn-secondary btn-sm" style="width: 100%; margin-top: 0.75rem;">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" style="width: 1rem; height: 1rem;">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75" />
                </svg>
                Salir
            </a>
        </div>
    </nav>

    <main class="main-content">
