<?php
$pageTitle = 'Filtros';
require_once __DIR__ . '/includes/layout.php';

$userId = getCurrentUserId();

$filters = dbFetchAll(
    "SELECT * FROM filters WHERE user_id = ? ORDER BY created_at DESC",
    [$userId]
);
?>
    <header class="page-header">
        <h1 class="page-title">Filtros</h1>
        <button class="btn btn-primary" data-modal="modal-filter">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" style="width: 1rem; height: 1rem;">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.5v15m7.5-7.5h-15" />
            </svg>
            Nuevo
        </button>
    </header>

    <div class="page-content">
        <div class="card" style="margin-bottom: 1.5rem;">
            <div class="card-body" style="display: flex; align-items: center; gap: 1rem;">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" style="width: 1.25rem; height: 1.25rem; color: #60a5fa;">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v3.75m-9.303 3.376c-.866 1.5.217 3.374 1.948 3.374h14.71c1.73 0 2.813-1.874 1.948-3.374L13.949 3.378c-.866-1.5-3.032-1.5-3.898 0L2.697 16.126zM12 15.75h.007v.008H12v-.008z" />
                </svg>
                <div>
                    <h4 style="font-weight: 600;">Cómo funcionan los filtros</h4>
                    <p style="font-size: 0.875rem; color: var(--text-muted);">Estos filtros se usarán para validar las propuestas que lleguen desde clawdbot. Define palabras clave, presupuesto mínimo, skills requeridos, etc.</p>
                </div>
            </div>
        </div>

        <?php if (empty($filters)): ?>
        <div class="card">
            <div class="empty-state">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 3c2.755 0 5.455.232 8.083.678.533.09.917.556.917 1.096v1.044a2.25 2.25 0 01-.659 1.591l-5.432 5.432a2.25 2.25 0 00-.659 1.591v2.927a2.25 2.25 0 01-1.244 2.013L9.75 21v-6.568a2.25 2.25 0 00-.659-1.591L3.659 7.409A2.25 2.25 0 013 5.818V4.774c0-.54.384-1.006.917-1.096A48.32 48.32 0 0112 3z" />
                </svg>
                <p>No hay filtros configurados</p>
                <p style="font-size: 0.875rem;">Crea filtros para validar automáticamente las propuestas entrantes</p>
            </div>
        </div>
        <?php else: ?>
            <div style="display: grid; gap: 1rem;">
                <?php foreach ($filters as $f): ?>
                <?php
                $criteria = json_decode($f['criteria'], true);
                $includeKeywords = $criteria['include_keywords'] ?? [];
                $excludeKeywords = $criteria['exclude_keywords'] ?? [];
                $minBudget = $criteria['min_budget'] ?? null;
                $skills = $criteria['skills'] ?? [];
                ?>
                <div class="card" style="border-left: 3px solid <?= $f['is_active'] ? '#60a5fa' : 'var(--bg-tertiary)' ?>;">
                    <div class="card-header" style="display: flex; align-items: center; justify-content: space-between;">
                        <div style="display: flex; align-items: center; gap: 0.75rem;">
                            <h3 class="card-title"><?= htmlspecialchars($f['name']) ?></h3>
                            <span class="badge" style="background: <?= $f['is_active'] ? 'rgba(34, 197, 94, 0.2); color: #22c55e;' : 'rgba(107, 114, 128, 0.2); color: #9ca3af;' ?>">
                                <?= $f['is_active'] ? 'Activo' : 'Inactivo' ?>
                            </span>
                        </div>
                        <div class="actions-cell">
                            <button class="btn btn-sm btn-secondary" onclick="toggleFilter(<?= $f['id'] ?>, <?= $f['is_active'] ? 'false' : 'true' ?>)">
                                <?= $f['is_active'] ? 'Desactivar' : 'Activar' ?>
                            </button>
                            <button class="btn btn-icon btn-sm" onclick="editFilter(<?= $f['id'] ?>)" title="Editar">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" style="width: 1rem; height: 1rem;">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L6.832 19.82a4.5 4.5 0 01-1.897 1.13l-2.685.8.8-2.685a4.5 4.5 0 011.13-1.897L16.863 4.487zm0 0L19.5 7.125" />
                                </svg>
                            </button>
                            <button class="btn btn-icon btn-sm" onclick="deleteFilter(<?= $f['id'] ?>)" title="Eliminar" style="color: var(--danger);">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" style="width: 1rem; height: 1rem;">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M14.74 9l-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 01-2.244 2.077H8.084a2.25 2.25 0 01-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 00-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 013.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 00-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 00-7.5 0" />
                                </svg>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem; font-size: 0.875rem;">
                            <?php if (!empty($includeKeywords)): ?>
                            <div>
                                <span style="color: var(--text-muted);">Incluir:</span>
                                <div style="margin-top: 0.25rem;">
                                    <?php foreach (array_slice($includeKeywords, 0, 3) as $kw): ?>
                                        <span class="badge" style="background: rgba(34, 197, 94, 0.2); color: #22c55e; margin-right: 0.25rem;"><?= htmlspecialchars($kw) ?></span>
                                    <?php endforeach; ?>
                                    <?php if (count($includeKeywords) > 3): ?>
                                        <span style="color: var(--text-muted);">+<?= count($includeKeywords) - 3 ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if (!empty($excludeKeywords)): ?>
                            <div>
                                <span style="color: var(--text-muted);">Excluir:</span>
                                <div style="margin-top: 0.25rem;">
                                    <?php foreach (array_slice($excludeKeywords, 0, 3) as $kw): ?>
                                        <span class="badge" style="background: rgba(220, 38, 38, 0.2); color: #f87171; margin-right: 0.25rem;"><?= htmlspecialchars($kw) ?></span>
                                    <?php endforeach; ?>
                                    <?php if (count($excludeKeywords) > 3): ?>
                                        <span style="color: var(--text-muted);">+<?= count($excludeKeywords) - 3 ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if ($minBudget): ?>
                            <div>
                                <span style="color: var(--text-muted);">Presupuesto mínimo:</span>
                                <div style="margin-top: 0.25rem; color: var(--text-primary);"><?= formatMoney((float)$minBudget) ?></div>
                            </div>
                            <?php endif; ?>

                            <?php if (!empty($skills)): ?>
                            <div>
                                <span style="color: var(--text-muted);">Skills:</span>
                                <div style="margin-top: 0.25rem;">
                                    <?php foreach (array_slice($skills, 0, 3) as $skill): ?>
                                        <span class="badge" style="background: var(--bg-tertiary); margin-right: 0.25rem;"><?= htmlspecialchars($skill) ?></span>
                                    <?php endforeach; ?>
                                    <?php if (count($skills) > 3): ?>
                                        <span style="color: var(--text-muted);">+<?= count($skills) - 3 ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <div class="modal-overlay" id="modal-filter">
        <div class="modal" style="max-width: 600px;">
            <div class="modal-header">
                <h3 class="modal-title">Nuevo Filtro</h3>
                <button class="modal-close" data-close>&times;</button>
            </div>
            <form id="form-filter" class="modal-body">
                <input type="hidden" name="id" id="filter-id">

                <div class="input-group">
                    <label class="input-label">Nombre *</label>
                    <input type="text" name="name" class="input" required placeholder="Ej: Proyectos React bien pagos">
                </div>

                <div class="input-group">
                    <label class="input-label">Palabras clave a incluir (separadas por coma)</label>
                    <textarea name="include_keywords" class="input" rows="2" placeholder="Ej: react, nextjs, typescript"></textarea>
                    <small style="color: var(--text-muted);">La propuesta debe contener al menos una de estas palabras</small>
                </div>

                <div class="input-group">
                    <label class="input-label">Palabras clave a excluir (separadas por coma)</label>
                    <textarea name="exclude_keywords" class="input" rows="2" placeholder="Ej: solo estudiantes, sin pago"></textarea>
                    <small style="color: var(--text-muted);">Se rechazarán propuestas que contengan estas palabras</small>
                </div>

                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                    <div class="input-group">
                        <label class="input-label">Presupuesto mínimo (USD)</label>
                        <input type="number" name="min_budget" class="input" step="0.01" placeholder="500">
                    </div>
                    <div class="input-group">
                        <label class="input-label">Presupuesto máximo (USD)</label>
                        <input type="number" name="max_budget" class="input" step="0.01" placeholder="5000">
                    </div>
                </div>

                <div class="input-group">
                    <label class="input-label">Skills requeridos (separados por coma)</label>
                    <input type="text" name="skills" class="input" placeholder="Ej: php, mysql, javascript">
                </div>
            </form>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-close>Cancelar</button>
                <button type="submit" form="form-filter" class="btn btn-primary">Guardar</button>
            </div>
        </div>
    </div>
</main>
<script src="/assets/js/app.js"></script>
<script src="/assets/js/filters.js"></script>
</body>
</html>
