<?php
$pageTitle = 'Dashboard';
require_once __DIR__ . '/includes/layout.php';

$userId = getCurrentUserId();

$stats = [
    'today' => dbFetchOne(
        "SELECT COUNT(*) as count FROM proposals WHERE user_id = ? AND DATE(created_at) = CURDATE()",
        [$userId]
    )['count'] ?? 0,
    'week' => dbFetchOne(
        "SELECT COUNT(*) as count FROM proposals WHERE user_id = ? AND YEARWEEK(created_at, 1) = YEARWEEK(CURDATE(), 1)",
        [$userId]
    )['count'] ?? 0,
    'pending' => dbFetchOne(
        "SELECT COUNT(*) as count FROM proposals WHERE user_id = ? AND status = 'pending'",
        [$userId]
    )['count'] ?? 0,
    'applied' => dbFetchOne(
        "SELECT COUNT(*) as count FROM proposals WHERE user_id = ? AND status = 'applied'",
        [$userId]
    )['count'] ?? 0,
];

$bySource = dbFetchAll(
    "SELECT source, COUNT(*) as count FROM proposals WHERE user_id = ? GROUP BY source ORDER BY count DESC",
    [$userId]
);

$recentProposals = dbFetchAll(
    "SELECT * FROM proposals WHERE user_id = ? ORDER BY created_at DESC LIMIT 5",
    [$userId]
);
?>
    <header class="page-header">
        <h1 class="page-title">Dashboard</h1>
        <div style="color: var(--text-muted); font-size: 0.875rem;">
            <?= date('l, d \d\e F \d\e Y') ?>
        </div>
    </header>

    <div class="page-content">
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(240px, 1fr)); gap: 1rem; margin-bottom: 2rem;">
            <div class="stat-card">
                <div class="stat-label">Propuestas Hoy</div>
                <div class="stat-value" style="color: #60a5fa;"><?= $stats['today'] ?></div>
            </div>
            <div class="stat-card">
                <div class="stat-label">Esta Semana</div>
                <div class="stat-value" style="color: #60a5fa;"><?= $stats['week'] ?></div>
            </div>
            <div class="stat-card">
                <div class="stat-label">Pendientes</div>
                <div class="stat-value" style="color: #fbbf24;"><?= $stats['pending'] ?></div>
            </div>
            <div class="stat-card">
                <div class="stat-label">Aplicadas</div>
                <div class="stat-value" style="color: #22c55e;"><?= $stats['applied'] ?></div>
            </div>
        </div>

        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); gap: 1.5rem; margin-bottom: 2rem;">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Por Fuente</h3>
                </div>
                <div class="card-body">
                    <?php if (empty($bySource)): ?>
                        <p style="color: var(--text-muted); font-size: 0.875rem;">No hay datos aún</p>
                    <?php else: ?>
                        <div style="display: flex; flex-direction: column; gap: 0.75rem;">
                            <?php
                            $total = array_sum(array_column($bySource, 'count'));
                            foreach ($bySource as $source):
                                $percent = $total > 0 ? round(($source['count'] / $total) * 100) : 0;
                            ?>
                            <div style="display: flex; align-items: center; justify-content: space-between;">
                                <div style="display: flex; align-items: center; gap: 0.75rem;">
                                    <span class="badge badge-<?= $source['source'] ?>"><?= htmlspecialchars(getSourceLabel($source['source'])) ?></span>
                                    <span style="color: var(--text-muted); font-size: 0.875rem;"><?= $source['count'] ?></span>
                                </div>
                                <div style="width: 100px; height: 6px; background: var(--bg-tertiary); border-radius: 9999px; overflow: hidden;">
                                    <div style="width: <?= $percent ?>%; height: 100%; background: var(--accent);"></div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="card">
                <div class="card-header" style="display: flex; align-items: center; justify-content: space-between;">
                    <h3 class="card-title">Propuestas Recientes</h3>
                    <a href="/proposals.php" style="font-size: 0.875rem; color: #60a5fa;">Ver todas</a>
                </div>
                <div class="card-body" style="padding: 0;">
                    <?php if (empty($recentProposals)): ?>
                        <div class="empty-state" style="padding: 2rem;">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m0 12.75h7.5m-7.5 3H12M10.5 2.25H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z" />
                            </svg>
                            <p>No hay propuestas aún</p>
                        </div>
                    <?php else: ?>
                        <table class="table" style="margin-bottom: 0;">
                            <tbody>
                                <?php foreach ($recentProposals as $p): ?>
                                <tr>
                                    <td style="width: 40%;">
                                        <div style="font-weight: 500;"><?= htmlspecialchars(truncateText($p['title'], 35)) ?></div>
                                    </td>
                                    <td>
                                        <span class="badge badge-<?= $p['source'] ?>"><?= htmlspecialchars(getSourceLabel($p['source'])) ?></span>
                                    </td>
                                    <td><?= getStatusBadge($p['status']) ?></td>
                                    <td style="color: var(--text-muted); font-size: 0.75rem;"><?= formatDate($p['created_at']) ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</main>
<script src="/assets/js/app.js"></script>
</body>
</html>
