const formTemplate = document.getElementById('form-template');
let isEditing = false;

formTemplate.addEventListener('submit', async (e) => {
    e.preventDefault();

    const formData = new FormData(formTemplate);
    const data = Object.fromEntries(formData);

    if (isEditing) {
        await Zao.put('/templates.php', data);
    } else {
        await Zao.post('/templates.php', data);
    }

    window.location.reload();
});

async function editTemplate(id) {
    const template = await Zao.get(`/templates.php?id=${id}`);

    document.getElementById('template-id').value = template.id;
    formTemplate.name.value = template.name;
    formTemplate.category.value = template.category || '';
    formTemplate.content.value = template.content;

    document.querySelector('#modal-template .modal-title').textContent = 'Editar Template';
    isEditing = true;
    Zao.showModal('modal-template');
}

async function deleteTemplate(id) {
    if (!confirm('¿Eliminar este template?')) return;

    await Zao.delete(`/templates.php?id=${id}`);
    window.location.reload();
}

async function copyTemplate(id) {
    const template = await Zao.get(`/templates.php?id=${id}`);
    Zao.copyToClipboard(template.content);
}

document.querySelector('[data-modal="modal-template"]')?.addEventListener('click', () => {
    isEditing = false;
    formTemplate.reset();
    document.getElementById('template-id').value = '';
    document.querySelector('#modal-template .modal-title').textContent = 'Nuevo Template';
});
