const formProposal = document.getElementById('form-proposal');
let isEditing = false;

formProposal.addEventListener('submit', async (e) => {
    e.preventDefault();

    const formData = new FormData(formProposal);
    const data = Object.fromEntries(formData);

    if (isEditing) {
        await Zao.put('/proposals.php', data);
    } else {
        await Zao.post('/proposals.php', data);
    }

    window.location.reload();
});

async function editProposal(id) {
    const proposal = await Zao.get(`/proposals.php?id=${id}`);

    document.getElementById('proposal-id').value = proposal.id;
    formProposal.title.value = proposal.title;
    formProposal.description.value = proposal.description || '';
    formProposal.source.value = proposal.source;
    formProposal.budget.value = proposal.budget || '';
    formProposal.url.value = proposal.url || '';
    formProposal.status.value = proposal.status;

    document.querySelector('#modal-proposal .modal-title').textContent = 'Editar Propuesta';
    isEditing = true;
    Zao.showModal('modal-proposal');
}

async function deleteProposal(id) {
    if (!confirm('¿Eliminar esta propuesta?')) return;

    await Zao.delete(`/proposals.php?id=${id}`);
    window.location.reload();
}

document.querySelector('[data-modal="modal-proposal"]')?.addEventListener('click', () => {
    isEditing = false;
    formProposal.reset();
    document.getElementById('proposal-id').value = '';
    document.querySelector('#modal-proposal .modal-title').textContent = 'Nueva Propuesta';
});
