const formFilter = document.getElementById('form-filter');
let isEditing = false;

formFilter.addEventListener('submit', async (e) => {
    e.preventDefault();

    const formData = new FormData(formFilter);
    const data = {
        id: formData.get('id') || null,
        name: formData.get('name'),
        include_keywords: formData.get('include_keywords')
            ? formData.get('include_keywords').split(',').map(s => s.trim()).filter(s => s)
            : [],
        exclude_keywords: formData.get('exclude_keywords')
            ? formData.get('exclude_keywords').split(',').map(s => s.trim()).filter(s => s)
            : [],
        min_budget: formData.get('min_budget') || null,
        max_budget: formData.get('max_budget') || null,
        skills: formData.get('skills')
            ? formData.get('skills').split(',').map(s => s.trim()).filter(s => s)
            : [],
    };

    if (isEditing) {
        await Zao.put('/filters.php', data);
    } else {
        await Zao.post('/filters.php', data);
    }

    window.location.reload();
});

async function editFilter(id) {
    const filter = await Zao.get(`/filters.php?id=${id}`);

    document.getElementById('filter-id').value = filter.id;
    formFilter.name.value = filter.name;
    formFilter.include_keywords.value = (filter.criteria.include_keywords || []).join(', ');
    formFilter.exclude_keywords.value = (filter.criteria.exclude_keywords || []).join(', ');
    formFilter.min_budget.value = filter.criteria.min_budget || '';
    formFilter.max_budget.value = filter.criteria.max_budget || '';
    formFilter.skills.value = (filter.criteria.skills || []).join(', ');

    document.querySelector('#modal-filter .modal-title').textContent = 'Editar Filtro';
    isEditing = true;
    Zao.showModal('modal-filter');
}

async function deleteFilter(id) {
    if (!confirm('¿Eliminar este filtro?')) return;

    await Zao.delete(`/filters.php?id=${id}`);
    window.location.reload();
}

async function toggleFilter(id, isActive) {
    await Zao.put('/filters.php', {
        id,
        is_active: isActive
    });
    window.location.reload();
}

document.querySelector('[data-modal="modal-filter"]')?.addEventListener('click', () => {
    isEditing = false;
    formFilter.reset();
    document.getElementById('filter-id').value = '';
    document.querySelector('#modal-filter .modal-title').textContent = 'Nuevo Filtro';
});
