<?php
declare(strict_types=1);
define('ZAO_ROOT', dirname(__DIR__));

require_once ZAO_ROOT . '/includes/db.php';
require_once ZAO_ROOT . '/includes/functions.php';

$config = require ZAO_ROOT . '/config.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['error' => 'Method not allowed'], 405);
}

$token = $_SERVER['HTTP_X_WEBHOOK_TOKEN'] ?? '';

if ($token !== $config['webhook_token']) {
    jsonResponse(['error' => 'Unauthorized'], 401);
}

$data = getRequestData();

$required = ['title', 'source'];
$errors = validateRequired($data, $required);

if (!empty($errors)) {
    jsonResponse(['errors' => $errors], 400);
}

$userId = $data['user_id'] ?? 1;

$proposalId = dbInsert('proposals', [
    'title' => $data['title'],
    'description' => $data['description'] ?? '',
    'source' => $data['source'],
    'url' => $data['url'] ?? '',
    'budget' => $data['budget'] ?? null,
    'status' => $data['status'] ?? 'pending',
    'user_id' => $userId,
]);

if ($proposalId) {
    $proposal = dbFetchOne("SELECT * FROM proposals WHERE id = ?", [$proposalId]);
    jsonResponse($proposal, 201);
}

jsonResponse(['error' => 'Error creating proposal'], 500);
