<?php
declare(strict_types=1);
define('ZAO_ROOT', dirname(__DIR__));

require_once ZAO_ROOT . '/includes/db.php';
require_once ZAO_ROOT . '/includes/auth.php';
require_once ZAO_ROOT . '/includes/functions.php';

header('Content-Type: application/json');

requireAuth();

$userId = getCurrentUserId();
$method = $_SERVER['REQUEST_METHOD'];
$id = (int)($_GET['id'] ?? 0);

if ($method === 'GET') {
    if ($id) {
        $template = dbFetchOne(
            "SELECT * FROM templates WHERE id = ? AND user_id = ?",
            [$id, $userId]
        );

        if (!$template) {
            jsonResponse(['error' => 'Not found'], 404);
        }

        jsonResponse($template);
    }

    $templates = dbFetchAll(
        "SELECT * FROM templates WHERE user_id = ? ORDER BY category, name",
        [$userId]
    );

    jsonResponse(['data' => $templates]);
}

if ($method === 'POST') {
    $data = getRequestData();

    $errors = validateRequired($data, ['name', 'content']);
    if (!empty($errors)) {
        jsonResponse(['errors' => $errors], 400);
    }

    $templateId = dbInsert('templates', [
        'name' => $data['name'],
        'content' => $data['content'],
        'category' => $data['category'] ?? null,
        'user_id' => $userId,
    ]);

    if ($templateId) {
        $template = dbFetchOne("SELECT * FROM templates WHERE id = ?", [$templateId]);
        jsonResponse($template, 201);
    }

    jsonResponse(['error' => 'Error creating template'], 500);
}

if ($method === 'PUT') {
    if (!$id) {
        jsonResponse(['error' => 'ID required'], 400);
    }

    $data = getRequestData();

    $existing = dbFetchOne("SELECT id FROM templates WHERE id = ? AND user_id = ?", [$id, $userId]);
    if (!$existing) {
        jsonResponse(['error' => 'Not found'], 404);
    }

    $updateData = [];

    foreach (['name', 'content', 'category'] as $field) {
        if (array_key_exists($field, $data)) {
            $updateData[$field] = $data[$field];
        }
    }

    if (!empty($updateData)) {
        dbUpdate('templates', $updateData, ['id' => $id, 'user_id' => $userId]);
    }

    $template = dbFetchOne("SELECT * FROM templates WHERE id = ?", [$id]);
    jsonResponse($template);
}

if ($method === 'DELETE') {
    if (!$id) {
        jsonResponse(['error' => 'ID required'], 400);
    }

    $existing = dbFetchOne("SELECT id FROM templates WHERE id = ? AND user_id = ?", [$id, $userId]);
    if (!$existing) {
        jsonResponse(['error' => 'Not found'], 404);
    }

    dbDelete('templates', ['id' => $id, 'user_id' => $userId]);
    jsonResponse(['success' => true]);
}

jsonResponse(['error' => 'Method not allowed'], 405);
