<?php
declare(strict_types=1);
define('ZAO_ROOT', dirname(__DIR__));

require_once ZAO_ROOT . '/includes/db.php';
require_once ZAO_ROOT . '/includes/auth.php';
require_once ZAO_ROOT . '/includes/functions.php';

header('Content-Type: application/json');

requireAuth();

$userId = getCurrentUserId();
$method = $_SERVER['REQUEST_METHOD'];
$id = (int)($_GET['id'] ?? 0);

if ($method === 'GET') {
    if ($id) {
        $filter = dbFetchOne(
            "SELECT * FROM filters WHERE id = ? AND user_id = ?",
            [$id, $userId]
        );

        if (!$filter) {
            jsonResponse(['error' => 'Not found'], 404);
        }

        $filter['criteria'] = json_decode($filter['criteria'], true);
        jsonResponse($filter);
    }

    $filters = dbFetchAll(
        "SELECT * FROM filters WHERE user_id = ? ORDER BY created_at DESC",
        [$userId]
    );

    foreach ($filters as &$f) {
        $f['criteria'] = json_decode($f['criteria'], true);
    }

    jsonResponse(['data' => $filters]);
}

if ($method === 'POST') {
    $data = getRequestData();

    $errors = validateRequired($data, ['name']);
    if (!empty($errors)) {
        jsonResponse(['errors' => $errors], 400);
    }

    $criteria = [
        'include_keywords' => $data['include_keywords'] ?? [],
        'exclude_keywords' => $data['exclude_keywords'] ?? [],
        'min_budget' => $data['min_budget'] ?? null,
        'max_budget' => $data['max_budget'] ?? null,
        'skills' => $data['skills'] ?? [],
    ];

    $filterId = dbInsert('filters', [
        'name' => $data['name'],
        'criteria' => json_encode($criteria),
        'is_active' => $data['is_active'] ?? true,
        'user_id' => $userId,
    ]);

    if ($filterId) {
        $filter = dbFetchOne("SELECT * FROM filters WHERE id = ?", [$filterId]);
        $filter['criteria'] = $criteria;
        jsonResponse($filter, 201);
    }

    jsonResponse(['error' => 'Error creating filter'], 500);
}

if ($method === 'PUT') {
    if (!$id) {
        jsonResponse(['error' => 'ID required'], 400);
    }

    $data = getRequestData();

    $existing = dbFetchOne("SELECT * FROM filters WHERE id = ? AND user_id = ?", [$id, $userId]);
    if (!$existing) {
        jsonResponse(['error' => 'Not found'], 404);
    }

    $updateData = [];
    $criteria = json_decode($existing['criteria'], true);

    if (array_key_exists('name', $data)) {
        $updateData['name'] = $data['name'];
    }

    if (array_key_exists('is_active', $data)) {
        $updateData['is_active'] = (bool)$data['is_active'];
    }

    if (isset($data['include_keywords'])) {
        $criteria['include_keywords'] = $data['include_keywords'];
    }
    if (isset($data['exclude_keywords'])) {
        $criteria['exclude_keywords'] = $data['exclude_keywords'];
    }
    if (isset($data['min_budget'])) {
        $criteria['min_budget'] = $data['min_budget'];
    }
    if (isset($data['max_budget'])) {
        $criteria['max_budget'] = $data['max_budget'];
    }
    if (isset($data['skills'])) {
        $criteria['skills'] = $data['skills'];
    }

    $updateData['criteria'] = json_encode($criteria);

    if (!empty($updateData)) {
        dbUpdate('filters', $updateData, ['id' => $id, 'user_id' => $userId]);
    }

    $filter = dbFetchOne("SELECT * FROM filters WHERE id = ?", [$id]);
    $filter['criteria'] = $criteria;
    jsonResponse($filter);
}

if ($method === 'DELETE') {
    if (!$id) {
        jsonResponse(['error' => 'ID required'], 400);
    }

    $existing = dbFetchOne("SELECT id FROM filters WHERE id = ? AND user_id = ?", [$id, $userId]);
    if (!$existing) {
        jsonResponse(['error' => 'Not found'], 404);
    }

    dbDelete('filters', ['id' => $id, 'user_id' => $userId]);
    jsonResponse(['success' => true]);
}

jsonResponse(['error' => 'Method not allowed'], 405);
