<?php
declare(strict_types=1);
define('ZAO_ROOT', dirname(__DIR__));

require_once ZAO_ROOT . '/includes/db.php';
require_once ZAO_ROOT . '/includes/auth.php';
require_once ZAO_ROOT . '/includes/functions.php';

header('Content-Type: application/json');

$action = $_GET['action'] ?? '';

if ($action === 'logout') {
    logout();
    jsonResponse(['success' => true]);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['error' => 'Method not allowed'], 405);
}

$data = getRequestData();
$email = $data['email'] ?? '';
$password = $data['password'] ?? '';
$remember = !empty($data['remember']);

if (!$email || !$password) {
    jsonResponse(['error' => 'Email y contraseña son requeridos'], 400);
}

if (login($email, $password, $remember)) {
    jsonResponse(['success' => true, 'user' => getCurrentUser()]);
}

jsonResponse(['error' => 'Credenciales inválidas'], 401);
